@echo off
rem **** This UPDATE.BAT file will copy and install the Baseball '94
rem **** version 1.01 patch disk to the specified hard drive and game
rem **** directory.  If no parameters are specified, it will first
rem **** check for the patch files already in the current directory.
rem **** If they are not there, it will attempt to install using the
rem **** default drives and directory, i.e., installing from A: to
rem **** C:\SIERRA\BASEBALL.

echo This batch file will update FPS: Baseball '94 version 1.00W to
echo version 1.01.  The proper syntax for using this installation
echo precedure is:
echo.
echo   UPDATE [source drive] [destination drive] [destination directory]
echo.
echo   Example:  UPDATE A: C: \SIERRA\BASEBALL
echo.
echo If the patch files are already in the game directory you may start
echo the patching process by simply typing:  UPDATE [ENTER]
echo.
echo Before patching Baseball, all saved games must be completed or
echo deleted.  If you continue with the patching process, the saved
echo games will be deleted for you.  If you do not want them deleted,
echo press CTRL+C now to exit the installation script and finish the
echo saved games before continuing with the patching process, or
pause

rem **** check to see if there are no parameters specified
if "%1"=="" goto noparms1
if "%2"=="" goto noparms1
if "%3"=="" goto noparms1

rem **** check the status of the 1st parameter and set F variable
:chkfd
if exist %1\patcha.rtp SET F=%1
if exist %1:\patcha.rtp SET F=%1:
if exist %F%\patcha.rtp goto chkhd
goto needparm

rem **** check the status of the 2nd parameter and set H variable
:chkhd
if exist %2\.. goto needparm
if exist %2\nul SET H=%2
if exist %2:\nul SET H=%2:
if exist %H%nul goto chkdr
goto needparm

rem **** check the status of the 3rd parameter and set D variable
:chkdr
if exist %H%%3shell.exe goto notrail
if exist %H%\%3\shell.exe SET D=\%3
if exist %H%%3\shell.exe SET D=%3
if not exist %H%%D%\shell.exe goto needparm

rem **** copy all files from disk 1 to game directory
%H%
cd %D%
cls
echo Copying patch files . . .
copy %F%\*.*

echo.
echo Now ready to begin applying the patch files . . .
pause

rem **** patch version 1.00W to 1.01
:patchit
chk4game -y
patch patcha.rtp
patch patchb.rtp
patch patchc.rtp
patch patchd.rtp assn
patch patche.rtp stadia


rem **** Check results of patch application.
cls
echo Now checking results of patching . . .
bbcheck
pause
goto end


rem **** If no parameters are specified, first check to see if the
rem **** files are in the game directory.  If they are, go directly to
rem **** patchit section, if not check the default drives and directory
rem **** of A: C: \SIERRA\BASEBALL.  If they aren't there, goto needparm.
:noparms1
if not exist .\patch.exe goto nope
if not exist .\patcha.rtp goto nope
if not exist .\patchb.rtp goto nope
if not exist .\patchc.rtp goto nope
if not exist .\patchd.rtp goto nope
if not exist .\patche.rtp goto nope
if not exist .\shell.exe goto nope
if not exist .\chk4game.exe goto nope
goto patchit

:nope
cls
echo Now checking for existence of patch disk in drive A: and game in
echo C:\SIERRA\BASEBALL.  If there is no disk in drive A:, you will
echo receive an "Abort, Retry, Fail" message on this step.  To clear
echo the message if it appears, either insert a formatted floppy disk
echo in drive A: and press "R" to "Retry" or press "F" to "Fail" the
echo check.
echo.
if not exist a:nul goto needparm
if not exist a:\patcha.rtp goto needparm
if not exist c:\sierra\baseball\shell.exe goto needparm

echo.
echo Before patching Baseball, all saved games must be completed or
echo deleted.  If you continue with the patching process, the saved
echo games will be deleted for you.  If you do not want them deleted,
echo press CTRL+C now to exit the installation script and finish the
echo saved games before continuing with the patching process, or
pause
echo.
echo Prepared to install the Baseball '94 version 1.01 patch
echo from floppy disk in drive A: to C:\SIERRA\BASEBALL.
echo.
echo If this is NOT correct, press CTRL+C now to terminate
echo execution of the install batch file, otherwise,
pause

echo.
echo Now copying patch files from C:\SIERRA\BASEBALL . . .

rem **** Actual execution of the default copy process
c:
cd \sierra\baseball
copy a:\*.*
goto patchit


rem **** Extra prompt for telling user not to put a trailing backslash on dir
:notrail
echo Don't use a trailing backslash on the directory name.

rem **** Bad or missing parameters procedure
:needparm
pause
echo You did not specify the proper source and destination paths and/or
ech drives.  The proper syntax for the installation is:
echo.
echo        UPDATE A: C: \SIERRA\BASEBALL
echo.
echo Replace the "A:" with the letter of the floppy drive with the patch
echo disk.  Replace the "C:" with the letter of the hard drive where
echo Baseball is installed.  Replace "\SIERRA\BASEBALL" with the directory
echo where Baseball is installed.
echo.
echo Note that you may specify the drives with or without the colon (both
echo A and A: are acceptable) and the directory with or without the
echo leading backslash (both \SIERRA\BASEBALL and SIERRA\BASEBALL are
echo acceptable).  The directory name cannot have a trailing backslash.
echo.
echo If no parameters are specified, the default drives and directory (as
echo shown in the above example) will be tried before providing this
echo prompt screen.
echo.
echo Please try again.
pause

rem **** Clean everything up by deleting the patch files and
rem **** clearing the variables.
:end
if exist %H%%D%\shell.exe del %H%%D%\patch*.*
SET F=
SET H=
SET D=
