#pragma option -mt -k- -p- -r- -G- -N-

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>


//The interrupt no
#define INTR_33 0x33

//structure to access stored register values in interrupt functions
struct INTR_REGS {
  unsigned bp, di, si, ds, es, dx, cx, bx, ax, ip, cs, fl;
};

int volatile mouseX;     //mouse cursor position
int volatile mouseY;     // ...
int volatile mouseMoveX; //mouse cursor relative move
int volatile mouseMoveY; // ...
int volatile mouseMaxX;  //max mouse cursor coordinate
int volatile mouseMaxY;  // ...
int volatile moveRateX;  //speed of mouse cursor
int volatile moveRateY;  // ...

//pointers to code
void interrupt (*oldhandler_33)(void);  //original handler of int 33h
void interrupt (*clientMouseCallback)(void); //client callback function

//callback function designed to keep track of mouse cursor allowing him for
//custom movement range on the screen
#pragma argsused
void interrupt mouseCallback(struct INTR_REGS r) {

  //if user haven't defined his own callback function...
  if(clientMouseCallback==NULL) {
   //clean up the stack after borland interrupt function
    asm pop bp
    asm pop di
    asm pop si
    asm pop ds
    asm pop es
    asm pop dx
    asm pop cx
    asm pop bx
    asm pop ax
    //...and leave
    asm retf
  }


  //if the callback's reason was a mouse move...
  if(r.ax&1) {
    //get the relative mouse move
    asm mov ax,0x0b
    asm pushf
    asm call cs:oldhandler_33
    asm mov mouseMoveX,cx
    asm mov mouseMoveY,dx
    //add relative mouse move to current position
    mouseX+=mouseMoveX*moveRateY;
    mouseY+=mouseMoveY*moveRateX;

  }
  //check for cursor out of bounds
  if(mouseX<0) mouseX=0;
  if(mouseY<0) mouseY=0;
  if(mouseX>mouseMaxX) mouseX=mouseMaxX;
  if(mouseY>mouseMaxY) mouseY=mouseMaxY;

  //give the client callback function new mouse cursor coordinates
  r.cx=mouseX;
  r.dx=mouseY;

  //clean up the stack after borland interrupt function
  asm pop bp
  asm pop di
  asm pop si
  asm pop ds
  asm pop es
  asm pop dx
  asm pop cx
  asm pop bx
  asm pop ax
  //chain to client callback function
  asm jmp cs:clientMouseCallback
}

void interrupt handler_33(struct INTR_REGS r) {

  //if client tries to setup his own callback function...
  if(r.ax==0x0c && r.cx!=0) {
    //set the client callback function to chain to
    clientMouseCallback=MK_FP(r.es,r.dx);
    //install our mouse callback function before client function
    r.es=FP_SEG(mouseCallback);
    r.dx=FP_OFF(mouseCallback);
  }

  //clean up the stack after borland interrupt function
  asm pop bp
  asm pop di
  asm pop si
  asm pop ds
  asm pop es
  asm pop dx
  asm pop cx
  asm pop bx
  asm pop ax

  /* transfer control to the old interrupt handler */
  asm jmp cs:oldhandler_33
}

int main(int argc, char** argv) {
  char* endptr;
  long param;
  int i;

  printf("MOUSE2KV v.1\nWin2k/NTVDM/VESA/Mouse utility by Peter Maceluch\n\n");
  printf("Designed to address the issues with mouse cursor being unable\nto reach whole screen in some DOS programs in Win2k\n\n");
  printf("Special thanks to Vlad ROMASCANU for MOUSESET sources this program\nwas based on.\n");

  if (argc < 6) {
    printf("Incorrect number of arguments\n  USAGE: MOUSE2KV xmax ymax xspeed yspeed program.exe\nwhere:\n"
    " xmax, ymax     - maximum coordinates for mouse cursor, \n"
    "      (when negative, the values are not multiplied internally by 8)\n"
    " xspeed, yspeed - multiplier for mouse speed (usually 8)\n"
    " program.exe    - program to launch with altered mouse support\n"
    "\n\neg. mouse2kv 640 480 8 8 xcomapoc.exe\n\n");
    return 1;
  }

  mouseMaxX=strtol(argv[1],NULL,0);
  mouseMaxY=strtol(argv[2],NULL,0);
  moveRateX=strtol(argv[3],NULL,0);
  moveRateY=strtol(argv[4],NULL,0);

  if(moveRateY==0 || moveRateX==0 || mouseMaxX==0 || mouseMaxY==0) {
    printf("Incorrect values entered in params\n");//("Are you sure you want to proceed?\n  y/n:");
    return 2;
  }

  if(mouseMaxX>0) mouseMaxX=(mouseMaxX-1)*8;
  else mouseMaxX=0-mouseMaxX;

  if(mouseMaxY>0) mouseMaxY=(mouseMaxY-1)*8;
  else mouseMaxY=0-mouseMaxY;


  clientMouseCallback=NULL;
  mouseX=0;
  mouseY=0;

  // get the address of the current interrupt
  oldhandler_33 = getvect(INTR_33);

  // install the new interrupt handler
  setvect(INTR_33, handler_33);

  // execute client program
  spawnvp(P_WAIT, argv[5], &(argv[5]));

  // set the old interrupt handler
  setvect(INTR_33, oldhandler_33);

  return 0;
}
